function [ p gof ] = expFitPVa( x )
%UNTITLED12 Summary of this function goes here
%   Detailed explanation goes here

x = reshape(x,length(x),1);
% Perform exponential fit of data
[lambda xmin L gof] = expFit(x);

% Make maximum possible value for generating synthetic sets 20 times that
% of the maximum value of x
mmax = 20*max(x);

nSets = 1000;

dat = zeros(1000,1);

z = x(x>=xmin); nz = length(z);
y = x(x<xmin);  ny = length(y);
N = nz + ny;

% cdf for exponential distribution above xmin
cdf = [1 - exp(-lambda.*((xmin:mmax)'-xmin))];

sgof = zeros(nSets,1);

% fprintf('Original lambda: %.4f\n', lambda);
% fprintf('Original xmin: %u\n\n',xmin);
% expPlot(x,xmin,lambda);
% title(gca,'Original exponential fit');

for i = 1:nSets
    
    % Generate synthetic data set, bootstrapping for values less than xmin
    
    % n1 is number of data points to be boostrapped
    n1 = sum(rand(N,1)<(ny/N));
    yS = y(ceil(rand(n1,1)*ny));

    n2 = N - n1;
    % generate synthetic data points by drawing from exponential CDF
    % simple discrete zeta generator
    r2 = sort(rand(n2,1));  c = 1;
    zS = zeros(n2,1);	k = 1;
    for j=xmin:mmax+1
        while c<=length(r2) && r2(c)<=cdf(j), c=c+1; end;
        zS(k:c-1) = j;
        k = c;
        if k>n2, break; end;
    end;
    S = [yS ; zS];
    
    % calculate exponential fit and gof for synthetic data set
    [lambdaS xminS LS sgof(i)] = expFit(S);
    
%     fprintf('Synthetic lambda: %.4f\n', lambdaS);
%     fprintf('Synthetic xmin: %u\n\n',xminS);
%     expPlot(S,xminS,lambdaS);
%     title(gca,sprintf('Synthetic exponential fit %u',i));
end

p = sum(sgof>gof)./nSets;
